;VBXE CONFIG UTILITY !
;VBXE1x Flash operator

        ;_TESTY = 1

        opt     l-
        icl     'atarihw.ah'
        icl     'atarios.ah'
        opt     l+

DATA0                   equ OR0
DCLK                    equ OR1
NCONFIG                 equ OR2
CFG2                    equ OR7
CONF_DONE               equ OR7
VBXECR                  equ $d7ff ;!!!!

CMD_NOP                 equ     0
CMD_BOOT                equ     0x10
CMD_STATUS              equ     0x14
CMD_VERSION             equ     0x18
CMD_TIMEOUT             equ     0x1c
CMD_DELETE              equ     0x20
CMD_RUN_CONFIG          equ     0x24
CMD_SET_AS_BOOTABLE     equ     0x28
CMD_READ_CFG_NAME       equ     0x30
CMD_WRITE_CFG_NAME      equ     0x34
CMD_READ_CFG_DATA       equ     0x40
CMD_WRITE_CFG_DATA      equ     0x44

VALID_IDENT             equ     0x51
VALID_IDENT_MASK        equ     0xfd
VALID_VERSION           equ     0x01
;----------------------------------------------------------------------------

;DLEN            equ 59215 ;dlugosc pliku konfiguracyjnego dla EP1K30
DLEN            equ 98023 ;dlugosc pliku konfiguracyjnego dla EP1K50

;HW interface zpg registers
bte     equ     $a0
hlp     equ     $a1
del     equ     $a2

;zero page various
fptr1   equ     $b0
fptr2   equ     $b2
fptr3   equ     $b4

gpr1    equ     $c0
gpr2    equ     $c1

;-----------------------------------------------------------
        org     $2400

Init    ldx     <weltxt
        ldy     >weltxt
        jmp     PUTLINE

weltxt  dta     c'VBXE flash utility v1.01 (D7xx)',$9b

        ini     Init

;-----------------------------------------------------------
        org     $2400

Start   tsx
        stx     stack_pointer

        WinSetup #winbuf

        ldx     #0
st2     stx     gpr1
        ldy     #8
st1     lsr     gpr1
        rol
        dey
        bne     st1
        sta     bit_reverse_table,x
        inx
        bne     st2

        jsr     ClearScreen
start1  jsr     VbxeInit
        jsr     LoadInfoData
start2  jsr     ShowMeAll

loop    GetKey
        cpy     #$1c
        jeq     prgexit
        
        ;ustawienie aktywnego banku
        cpy     #$0e  ;strzaka gra
        jeq     bank_down
        cpy     #$0f  ;strzaka d
        jeq     bank_up
        cpy     #$2c  ;TAB
        jeq     bank_up
        lda     GetKey.atascii_lowercase
        cmp     #'1'
        jcc     l2
        cmp     #'4'+1
        jcs     l2
        sbc     #'1'-1
        jmp     set_active_bank

        ;sprawdzenie operacji dozwolonych na wybranym banku
l2      lda     bank_selected
        jsr     CheckBankStatus
        jeq     loop
        jmi     l3

        ;tylko w nie-pustych bankach
        cpy     #$a8 ;Ctrl+R
        jeq     name_update
        cpy     #$8b ;Ctrl+U
        jeq     cfg_update
        lda     GetKey.atascii_lowercase
        cmp     #'s'
        jeq     save_xbf
        cmp     #'b'
        jeq     set_bootbank
        cmp     #'d'
        jeq     delete_cfg
        cmp     #'x'
        jeq     start_cfg
        cpy     #$0c ;RETURN w uywanym banku
        jeq     start_cfg

l3
        ;we wszystkich dostpnych bankach
        ;pustych lub nie-pustych
        cpy     #$80 ;Ctrl+L
        jeq     load_rbf
        cpy     #$0c ;RETURN w pustym banku
        jeq     load_xbf
        lda     GetKey.atascii_lowercase
        cmp     #'l'
        jeq     load_xbf

        ;koniec ptli klawiatury
        jmp     loop


bank_up .local
bu1     lda     bank_selected
        add     #1
        and     #3
        jsr     CheckBankStatus
        jeq     bu1
        stx     bank_selected
        jmp     start2
        .endl

bank_down .local
bd1     lda     bank_selected
        sub     #1
        and     #3
        jsr     CheckBankStatus
        jeq     bd1
        stx     bank_selected
        jmp     start2
        .endl

prgexit ldx     <qtxt
        ldy     >qtxt
        jmp     PUTLINE
qtxt    .byte   $7d,'VBXE (c) 2006-2007 ELECTRON',$9b

set_bootbank .local
        lda     bank_selected
        ora     #CMD_SET_AS_BOOTABLE
        TraStart @
        jsr     TraStop
        jmp     start1
        .endl

save_xbf .local

        FileBoxExecute #fmask2 #dirbuf #dirbuf_len
        jmi     start2

        WinCreate #4 #6 #30 #7
        SetCursor #0 #2 #2
        PutText #tsaving #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        SetCursor #0 #2 #4

        FileOpen #fm.fname #CIO_write
        jmi     serr

        mva     #DLEN/65536 gpr1
        mwa     #DLEN%65536 fptr2

        TraStart #CMD_TIMEOUT
        lda     #30
        sta     TraStart.timeout
        jsr     TraByte
        jsr     TraStop

        lda     #CMD_READ_CFG_DATA
        ora     bank_selected
        TraStart @

sv_get  lda     fptr2
        sta     fptr1
        sub     #cfgbuf_len%256
        sta     fptr2
        lda     fptr2+1
        sta     fptr1+1
        sbc     #cfgbuf_len/256
        sta     fptr2+1
        lda     gpr1
        sbc     #0
        sta     gpr1
        jcs     svg1
        lda     #0
        sta     fptr2
        sta     fptr2+1
        sta     gpr1
        jcc     svg2
svg1    mwa     #cfgbuf_len fptr1
svg2    mwa     #cfgbuf svg4+1
        mwa     fptr1 fptr3
        jsr     Fast
svg3    jsr     TraByte
        tax
        lda     bit_reverse_table,x
        sta     COLBAK
svg4    sta     $ffff
        inw     svg4+1
        dew     fptr1
        lda     fptr1
        ora     fptr1+1
        jne     svg3
        jsr     Slow
        SetupTransfer #cfgbuf #CIO_putdata
        jmi     serrs
        NextTransfer fptr3
        jmi     serrs
        lda     fptr2
        ora     fptr2+1
        ora     gpr1
        jne     sv_get
        jsr     TraStop
        Mul8    bank_selected #33
        mwa     Mul8.result fptr1
        adw     fptr1 #b1_info
        SetupTransfer fptr1 #CIO_putdata
        jmi     serr
        NextTransfer #33
        jmi     serr
        FileClose
        PutText #LoadFile.tend #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        jmp     svg9
serrs   jsr     TraStop
serr    FileClose
        PutText #LoadFile.tverr #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
svg9    GetKey
        WinDestroy
        jmp     start1

tsaving .byte   "Saving Bx CFG data as XBF",INTD

        .endl

name_update
        LoadFile #LF_GET_NAME_FROM_KEYBOARD #0
        jmp     start1

cfg_update
        LoadFile #LF_GET_CFG_FORM_FILE #fmask1
        jmp     start1

load_xbf LoadFile #LF_GET_NAME_FROM_FILE+LF_GET_CFG_FORM_FILE #fmask2
        jmp     start1

load_rbf LoadFile #LF_GET_NAME_FROM_KEYBOARD+LF_GET_CFG_FORM_FILE #fmask1
        jmp     start1

fmask1  .byte   '*.RBF',$9b
fmask2  .byte   '*.XBF',$9b

        LF_GET_NAME_FROM_KEYBOARD = 1
        LF_GET_NAME_FROM_FILE = 2
        LF_GET_CFG_FORM_FILE = 4

LoadFile .proc (.byte com .word fptr1) .var

        ;wybr pliku (xbf/rbf)
        lda     com
        and     #LF_GET_CFG_FORM_FILE
        jeq     lf1

        FileBoxExecute fptr1 #dirbuf #dirbuf_len
        spl
        rts

lf1     lda     com
        and     #LF_GET_NAME_FROM_KEYBOARD
        jeq     lf3
        ;prosimy o podanie nazwy
        WinCreate #1 #9 #37 #7
        SetCursor #0 #2 #2
        PutText #tpodaj #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        SetCursor #0 #2 #4
lr1     GetText #0 #33 #GT_SPACES
        jpl     lr2
        WinDestroy
        rts
lr2     lda     GetText.len
        jeq     lr1
        Mul8    bank_selected #33
        mwa     Mul8.result fptr1
        adw     fptr1 #b1_info
        PutText PutChar.adr fptr1 #32 #INTD #SRC_INTERNAL+DST_ATASCII
        PutCh   #0
        WinDestroy

lf3     WinCreate #6 #4 #26 #13

        TraStart #CMD_TIMEOUT
        lda     #30
        sta     TraStart.timeout
        jsr     TraByte
        jsr     TraStop

        lda     com
        and     #LF_GET_CFG_FORM_FILE
        jeq     lf4
        ;programowanie flash
        FileOpen #fm.fname #CIO_Read
        jmi     err

        SetCursor #0 #2 #2
        PutText #tprog #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        SetCursor #0 #2 #4

        mva     #DLEN/65536 gpr1
        mwa     #DLEN%65536 fptr2
        mwa     #0 fptr1

        lda     #CMD_WRITE_CFG_DATA
        ora     bank_selected
        TraStart @

prgloop lda     fptr1
        jne     prgb1
        lda     fptr1+1
        jeq     prgblockload
        dec     fptr1+1
prgb1   dec     fptr1
prgbyte ldx     $ffff
        stx     COLBAK
        lda     bit_reverse_table,x
        jsr     TraByte
        inc     prgbyte+1
        jne     prgloop
        inc     prgbyte+2
        jmp     prgloop
prgblockload
        jsr     Slow
        PutCh   #0x80
        lda     gpr1
        ora     fptr2
        ora     fptr2+1
        jeq     prgend
        mwa     #cfgbuf prgbyte+1
        mwa     #cfgbuf_len fptr1
        lda     gpr1
        jne     prgb2
        lda     fptr2
        cmp     #cfgbuf_len%256
        lda     fptr2+1
        sbc     #cfgbuf_len/256
        bcs     prgb2
        mwa     fptr2 fptr1
prgb2   SetupTransfer #cfgbuf #CIO_getdata
        jmi     errstop
        NextTransfer fptr1
        jmi     errstop
        lda     fptr2
        sub     fptr1
        sta     fptr2
        lda     fptr2+1
        sbc     fptr1+1
        sta     fptr2+1
        lda     gpr1
        sbc     #0
        sta     gpr1
        PutCh   #0x80
        PutCh   #0x80
        jsr     Fast
        jmp     prgloop
prgend  jsr     TraStop
        lda     com
        and     #LF_GET_NAME_FROM_FILE
        jeq     non
        Mul8    bank_selected #33
        mwa     Mul8.result fptr1
        adw     fptr1 #b1_info
        SetupTransfer fptr1 #CIO_getdata
        jmi     errstop
        NextTransfer #33
        jmi     errstop
non     jsr     FileClose

lf4     lda     com
        and     #LF_GET_NAME_FROM_KEYBOARD+LF_GET_NAME_FROM_FILE
        jeq     lf5
        lda     #CMD_WRITE_CFG_NAME
        ora     bank_selected
        TraStart @
        Mul8    bank_selected #33
        mwa     Mul8.result fptr1
        adw     fptr1 #b1_info
fcn1    ldy     #0
        lda     (fptr1),y
        inw     fptr1
        pha
        jsr     TraByte
        pla
        jne     fcn1
        jsr     TraStop
        lda     com
        and     #LF_GET_CFG_FORM_FILE
        jne     lf5
        SetCursor #0 #2 #2
        PutText #tprog1 #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
lf5     PutText #tok #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL

        ;weryfikacja
        lda     com
        and     #LF_GET_CFG_FORM_FILE
        jeq     lf6

        FileOpen #fm.fname #CIO_Read
        jmi     err

        SetCursor #0 #2 #6
        PutText #tveri #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        SetCursor #0 #2 #8

        mva     #DLEN/65536 gpr1
        mwa     #DLEN%65536 fptr2
        mwa     #0 fptr1

        lda     #CMD_READ_CFG_DATA
        ora     bank_selected
        TraStart @

veriloop
        lda     fptr1
        jne     vrib1
        lda     fptr1+1
        jeq     veriblockload
        dec     fptr1+1
vrib1   dec     fptr1
        jsr     TraByte
        tax
        lda     bit_reverse_table,x
        sta     COLBAK
vribyte cmp     $ffff
        .if .not .def _TESTY
        jne     verifailure
        .endif
        inc     vribyte+1
        jne     veriloop
        inc     vribyte+2
        jmp     veriloop
veriblockload
        jsr     Slow
        PutCh   #0x80
        lda     gpr1
        ora     fptr2
        ora     fptr2+1
        jeq     veriend
        mwa     #cfgbuf vribyte+1
        mwa     #cfgbuf_len fptr1
        lda     gpr1
        jne     vrib2
        lda     fptr2
        cmp     #cfgbuf_len%256
        lda     fptr2+1
        sbc     #cfgbuf_len/256
        bcs     vrib2
        mwa     fptr2 fptr1
vrib2   SetupTransfer #cfgbuf #CIO_getdata
        jmi     errstop
        NextTransfer fptr1
        jmi     errstop
        lda     fptr2
        sub     fptr1
        sta     fptr2
        lda     fptr2+1
        sbc     fptr1+1
        sta     fptr2+1
        lda     gpr1
        sbc     #0
        sta     gpr1
        PutCh   #0x80
        PutCh   #0x80
        jsr     Fast
        jmp     veriloop
veriend jsr     TraStop
        FileClose

lf6     lda     com
        and     #LF_GET_NAME_FROM_KEYBOARD+LF_GET_NAME_FROM_FILE
        jeq     lf7
        lda     #CMD_READ_CFG_NAME
        ora     bank_selected
        TraStart @
        Mul8    bank_selected #33
        mwa     Mul8.result fptr1
        adw     fptr1 #b1_info
fv1     jsr     TraByte
        .if .not .def _TESTY
        ldy     #0
        cmp     (fptr1),y
        jne     verifailure
        .endif
        tay
        jeq     fv2
        inw     fptr1
        jmp     fv1
fv2     jsr     TraStop
        lda     com
        and     #LF_GET_CFG_FORM_FILE
        jne     lf7
        SetCursor #0 #2 #4
        PutText #tveri1 #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
lf7     PutText #tok #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL

        SetCursor #0 #2 #10
        PutText #tend #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        GetKey
        WinDestroy
        ldy     #0
        rts

verifailure
errstop jsr     TraStop
err     FileClose
        SetCursor #0 #2 #10
        PutText #tverr #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        GetKey
        WinDestroy
        ldy     #255
        rts

tpodaj  .byte   "Enter short CFG description",INTD
tprog   .byte   "FLASH Programming",INTEOL,INTEOL
        .byte   "-------------------",INTD
tprog1  .byte   "NAME update",INTD
tveri   .byte   "Verification",INTEOL,INTEOL
        .byte   "-------------------",INTD
tveri1  .byte   "NAME verify",INTD
tok     .byte   " OK",INTD
tverr   .byte   "Error! "
tend    .byte   "Press any key",INTD
com     .byte   0

        .endp

delete_cfg .local
        lda     #CMD_DELETE
        ora     bank_selected
        TraStart @
        jsr     TraStop
        jmp     start1
        .endl

start_cfg .local
        lda     #CMD_RUN_CONFIG
        ora     bank_selected
        TraStart @
        jsr     TraStop
        WinCreate #11 #8 #15 #5
        SetCursor #0 #2 #2
        PutText #tbot #0 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        Delay #50*8
        WinDestroy
        jmp     start1

tbot    .byte   "Booting ...",INTD

        .endl

set_active_bank .local

        pha
        jsr     CheckBankStatus
        jeq     sab1
        pla
        sta     bank_selected
        jmp     start2
sab1    pla
        jmp     loop

        .endl

;bank status:
;Z = 1 - not available
;Z = 0, N = 1 - empty
;Z = 0, N = 0 - used
;Z = 0, N = 0, C = 0 - used, not bootable
;Z = 0, N = 0, C = 1 - used, bootable

CheckBankStatus .local

        cmp     #4
        bcs     cbs4
        tax
        lda     bmask,x
        and     bank_mask
        jeq     cbs1
        and     bank_status
        jeq     cbs2
        clc
        lda     bmask,x
        and     #0xf0
        and     bank_status
        seq
        sec
        lda     #1
        rts
cbs2    lda     #255
cbs1    rts
cbs4    lda     #0
        rts

bmask   .byte   0x11,0x22,0x44,0x88

        .endl

LoadInfoData .local
        TraStart #CMD_TIMEOUT
        lda     #255
        sta     TraStart.timeout
        jsr     TraByte
        jsr     TraStop

        TraStart #CMD_STATUS
        jsr     TraByte
        sta     bank_mask
        jsr     TraByte
        sta     bank_status
        jsr     TraStop

        TraStart #CMD_VERSION
        jsr     TraByte
        sta     fw_revision
        LoadString #fw_info
        jsr     TraStop

        .if .def _TESTY
        mva     #VALID_IDENT interface_ident
        mva     #VALID_VERSION fw_revision
        mva     #0x0f bank_mask
        mva     #0x11 bank_status
        .endif

        lda     interface_ident
        and     #VALID_IDENT_MASK
        cmp     #VALID_IDENT
        jne     TraByte.Terminate
        lda     fw_revision
        cmp     #VALID_VERSION
        jne     TraByte.Terminate

        lda     #0
        sta     gpr1
        mwa     #b1_info fptr1

lid0    lda     gpr1
        jsr     CheckBankStatus
        jeq     lid1
        jmi     lid2
        lda     gpr1
        ora     #CMD_READ_CFG_NAME
        TraStart @
        LoadString fptr1
        jsr     TraStop
lid2    adw     fptr1 #33
        inc     gpr1
        jne     lid0
lid1    rts

        .endl

ClearScreen .local

        ;skasuj zawarto ekranu
        mwa     SAVMSC fptr1
        ldx     #24
l1      ldy     #39
        lda     #0
l2      sta     (fptr1),y
        dey
        bpl     l2
        adw     fptr1 #40
        dex
        bne     l1
        rts

        .endl

ShowMeAll .local

        Hex2    #iit, interface_ident
        Hex2    #frt, fw_revision

        PutText #fw_info #vst #32 #0 #SRC_ASCII+DST_INTERNAL

        ;wypisz nazwy konfiguracji w bankach
        ;zaznacz wybrany bank
        lda     #0
        sta     bused
        sta     bavail
        sta     bboot
        lda     bank_mask
        sta     gpr1
        lda     bank_status
        sta     gpr2
        mwa     #b1_info fptr1
        mwa     #bt1 fptr2
        ldx     #3
l24     lda     #"B"
        sta     bnrtxt
        txa
        eor     #3
        clc
        adc     #"1"
        sta     bnrtxt+1
        sbc     #"1"-1
        eor     bank_selected
        jne     l33
        ldy     #1
l32     lda     bnrtxt,y
        ora     #$80
        sta     bnrtxt,y
        dey
        bpl     l32
l33     PutText #bnrtxt fptr2 #3 #INTD #SRC_INTERNAL+DST_INTERNAL
        lda     gpr2
        and     gpr1
        and     #1
        bne     l21
        lda     gpr1
        and     #1
        bne     l23
        PutText #navtxt #0 #32 #INTD #SRC_INTERNAL+DST_INTERNAL
        jmp     l22
l23     PutText #emptxt #0 #32 #INTD #SRC_INTERNAL+DST_INTERNAL
        inc     bavail
        jmp     l22
l21     PutText fptr1 #0 #32 #0 #SRC_ATASCII+DST_INTERNAL
        inc     bavail
        inc     bused
        lda     gpr2
        and     #0x10
        jeq     l22
        txa
        eor     #3
        add     #"1"
        sta     bboot
l22     lsr     gpr2
        lsr     gpr1
        adw     fptr1 #33
        adw     fptr2 #(bt2-bt1)
        dex
        jpl     l24

        ;przygotuj informacje o bankach
        lda     bused
        ora     #"0"
        sta     tut
        lda     bavail
        ora     #"0"
        sta     tbt
        lda     #"-"
        sta     bbt
        lda     #" "
        sta     bbt+1
        lda     bboot
        jeq     wt
        sta     bbt+1
        lda     #"B"
        sta     bbt

        ;wypisz teksty
wt      mwa     SAVMSC fptr2
        adw     fptr2 #1
        PutText #texts fptr2 #0 #INTD #SRC_INTERNAL+DST_INTERNAL
        rts

texts   .byte " VBXE flash utility v1.01 (D6xx) "*,INTEOL
        .byte INTEOL
        .byte " Device summary "*,INTEOL
        .byte INTEOL
        .byte "Interface Ident: 0x"
iit     .byte "xx",INTEOL
        .byte "Firmware Revision: 0x"
frt     .byte "xx",INTEOL
        .byte "Info: "
vst     :32 .byte 0
        .byte INTEOL
        .byte INTEOL
        .byte " Flash memory status "*,INTEOL
        .byte INTEOL
tbt     .byte "x Bank(s) Total, "
tut     .byte "x Used, BootBank: "
bbt     .byte "- ",INTEOL
        .byte INTEOL
bt1     .byte "B1:"
        :32 .byte 0
        .byte INTEOL
bt2     .byte "B2:"
        :32 .byte 0
        .byte INTEOL
bt3     .byte "B3:"
        :32 .byte 0
        .byte INTEOL
bt4     .byte "B4:"
        :32 .byte 0
        .byte INTEOL
        .byte INTEOL
        .byte " Actions "*,INTEOL
        .byte INTEOL
        .byte "[1234]=Bank Select (if available)",INTEOL
        .byte "[L/RET]=Load XBF [Ctrl+L]=Load RBF",INTEOL
        .byte "[S]=Save XBF",INTEOL
        .byte "[D]=Delete Cfg [X/RET]=Start Cfg",INTEOL
        .byte "[B]=Set as BootBank [Esc]=Exit"
        .byte INTD

navtxt  .byte "(not available)",INTD
emptxt  .byte "(empty)",INTD
bnrtxt  .byte "B1:",INTD
bused   .byte 0
bavail  .byte 0
bboot   .byte 0

        .endl

LoadString .proc (.word ls+1) .var

        ldx     #0
ls2     stx     indx
        jsr     TraByte
        ldx     indx
ls      sta     $ffff,x
        tay
        sne
        rts
        inx
        cpx     #32
        bcc     ls2
        lda     #0
        jeq     ls

indx    .byte   0

        .endp

Hex2    .proc (.word h3+1 .byte vx+1) .var

        txa
        pha
        ldx     #0
vx      lda     #0
h2      pha
        lsr
        lsr
        lsr
        lsr
        jsr     h1
        pla
        and     #$f
        jsr     h1
        pla
        tax
        rts
h1      sub     #$a
        bcc     h0
        adc     #"A"-"0"-1
h0      adc     #"0"+$0a
h3      sta     $ffff,x
        inx
        rts

        .endp

Fast    .local
        lda     #0
        sta     NMIEN
        sei
        lda     TraStart.command
        and     #$fc
        cmp     #CMD_TIMEOUT
        jeq     ts1
        lda     TraStart.timeout
        cmp     #150
        jcs     ts1
        lda     VCOUNT
        rne
        sta     DMACTL
ts1     rts
        .endl

Slow    .local
        lda     #$40
        sta     NMIEN
        cli
        lda     TIMER
        cmp     TIMER
        req
        lda     DMACTLS
        sta     DMACTL
        rts
        .endl


bank_selected .byte 0

interface_ident org *+1
fw_revision org *+1
fw_info org *+33
b1_info org *+33
b2_info org *+33
b3_info org *+33
b4_info org *+33
bank_status org *+1
bank_mask org *+1
stack_pointer org *+1
bit_reverse_table org *+256
;--------------------------------------
;vbxe hw low level transfer (BEGIN)

TraStart .proc (.byte command) .var
        jsr     Fast
        lda     #NCONFIG+CFG2
        sta     VBXECR
        lda     command
        TraByte @
        sta     interface_ident
        and     #VALID_IDENT_MASK
        cmp     #VALID_IDENT
        jne     TraByte.Terminate
        rts
command .byte   0
timeout .byte   0
        .endp

TraByte .proc
        .if .def _TESTY
        lda     #0
        rts
        .endif
        sta     bte
        ldx     #8
        lda     #40 ;opnienie dla bitu 0 = ((del-1) * 256 + 50) * 11 cykli
        ;20 == okoo 30 ms.
tb1     sta     del
        ldy     #50
        lda     #DATA0+DCLK+CFG2+NCONFIG
        lsr     bte
        bcs     tb2
        lda     #DCLK+CFG2+NCONFIG
        ;nadaj bit do vbxe
tb2     asl     bte
        sta     VBXECR
        lda     #DCLK
        ;czekaj na odebranie bitu przez vbxe
        ;i na nadanie bitu przez vbxe
tb3     and     VBXECR
        beq     tb4
        dey
        bne     tb3
        and     VBXECR
        beq     tb4
        dec     del
        bne     tb3
        ;timeout - error
Terminate
        jsr     TraStop
        ldx     stack_pointer
        txs
        ldx     <errtxt
        ldy     >errtxt
        jmp     PUTLINE
errtxt  .byte   $7d,'VBXE IO error',$9b
        ;odbierz bit od vbxe (C = 0 po "asl bte")
tb4     lda     VBXECR
        and     #DATA0
        seq
        sec
        ror     bte
        ;bit odebrany
        ;czekaj na timeout vbxe
        sta     hlp
        eor     #DATA0
        ora     #CFG2+NCONFIG
        sta     VBXECR
tb5     lda     hlp
        eor     VBXECR
        and     #DATA0
        beq     tb5
        ;timeout vbxe
        ;mona nadawa kolejny bit
        lda     #1
        dex
        bne     tb1
        lda     bte
        rts
        .endp

TraStop .proc
        jsr     Slow
        lda     #NCONFIG
        sta     VBXECR
        Delay   #3
        rts
        .endp

VbxeInit .proc
        .if .def _TESTY
        rts
        .endif
        ; ustawiam timeout
        ; x - modszy
        ; y - starszy
        ldx     #255
        ldy     #10
        ; wysyam do kontrolera sygna "zwolnij rejestr" (CFG2 = 0)
        ; oraz ustawiam lini DATA na 1 dla sprawdzenia za chwil
vi1     lda     #NCONFIG+DATA0
        sta     VBXECR
        ; czekaj na gotowo VBXE
        ; czyli do DATA = 1, NCONFIG = 1
        txa
        sne
        dey
        dex
        tya
        spl
        jmp     TraByte.Terminate
        lda     VBXECR
        eor     #DATA0+NCONFIG
        and     #DATA0+NCONFIG
        jne     vi1
        ; jest DATA = 1, NCONFIG = 1
        ; ustawiam NCONFIG = 1, DATA = 0, DCLK = 0, CFG2 = 0
        lda     #NCONFIG
        sta     VBXECR
        ; sprawdzam, czy rzeczywicie steruj liniami
        ; NCONFIG powinno by teraz = 1 i DATA = 0;
        lda     VBXECR
        eor     #NCONFIG
        and     #DATA0+NCONFIG
        jne     vi1
        ; VBXE gotowe
        rts
        .endp

;vbxe hw low level transfer (END)
;-----------------------------------------------------------

        ;opt     l-
        icl     'filebox.asm'
        ;opt     l+

;-----------------------------------------------------------
init2   jmp     FileBoxInit

dirbuf_len      equ     0x1000
cfgbuf_len      equ     0x4000

dirbuf  equ     *
cfgbuf  org     *+cfgbuf_len
winbuf  equ     *

        ini     init2
        run     Start

        end
